SELECT
    'type ' || table_name || ' struct {' || CHR(10) || fields || CHR(10) || '}' AS models
FROM
    (
        SELECT
            table_name,
            REPLACE(RTRIM(XMLAGG(XMLELEMENT(E, CHR(9) || column_name || CHR(9) || type_info || CHR(9) || annotation || CHR(10))).EXTRACT('//text()').GETCLOBVAL(), CHR(10)), '&quot;', '"') AS fields
        FROM
            (
                SELECT
                    REPLACE(INITCAP(table_name), '_', '') AS table_name,
                    REPLACE(INITCAP(column_name), '_', '') AS column_name,
                    CASE data_type
                        WHEN 'TIMESTAMP' THEN 'time.Time'
                        WHEN 'TIMESTAMP(6)' THEN 'time.Time'
                        WHEN 'TIMESTAMP WITH TIME ZONE' THEN 'time.Time'
                        WHEN 'TIMESTAMP WITH LOCAL TIME ZONE' THEN 'time.Time'
                        WHEN 'LONG' THEN 'int64'
                        WHEN 'NUMBER' THEN
                            CASE
                                WHEN data_precision IS NULL AND data_scale = 0 THEN 'int'
                                WHEN data_precision IS NOT NULL AND data_scale = 0 THEN 'int64'
                                ELSE 'float64'
                            END
                        WHEN 'FLOAT' THEN 'float32'
                        WHEN 'BINARY_FLOAT' THEN 'float32'
                        WHEN 'BINARY_DOUBLE' THEN 'float64'
                        WHEN 'CHAR' THEN 'string'
                        WHEN 'VARCHAR2' THEN 'sql.NullString'
                        WHEN 'NCHAR' THEN 'string'
                        WHEN 'NVARCHAR2' THEN 'string'
                        WHEN 'CLOB' THEN 'go_ora.Clob'
                        WHEN 'NCLOB' THEN 'go_ora.Nlob'
                        WHEN 'BLOB' THEN 'go_ora.Blob'
                        WHEN 'DATE' THEN 'go_ora.NullTimeStamp'
                        WHEN 'RAW' THEN '[]byte'
                        WHEN 'UNDEFINED' THEN 'database.OraUNDEFINED'
                        -- add your own type converters as needed or it will default to 'string'
                        ELSE 'UNKNOWN'
                    END AS type_info,
                    '`json:"' || column_name || '" db:"' || column_name || '"`' AS annotation
                FROM all_tab_columns
                WHERE owner = 'DELOPRO'
            )
        --WHERE type_info = 'UNKNOWN'
        GROUP BY table_name
    )
--WHERE table_name = 'V8EventVw'
ORDER BY table_name